var Profile = new Class({
  Implements: [Options, Events],
	options: {
		// informacie o pouzivatelovi ktore je mozne menit
		editable: ['nick', 'email', 'web', 'phone', 'name', 'surname', 'address', 'profile'],
		width: 421, 
		height: 442
	},
	owner: null,
  el: null,
	window: null,
	native_window: null,
	info: null,
	data_changed: false, // ci sa zmenil obsah profilu po otvoreni
	
	initialize: function(o, options, info){
		this.owner = o;
    this.setOptions(options);
		this.info = info;
				
		var t = this;
		var title = "CLIM - " + this.info.nick + " (profil)";
		
		// create new window
		this.window = window.open("profile.html", title, "height=" + this.options.height + ", width=" + this.options.width);
		this.native_window = this.window.nativeWindow;
		
		this.window.document.title = title;
		this.window.opener = this;
		
		// assign onClose event
		this.native_window.addEventListener(air.Event.CLOSE, function(){t.onClose();});
		this.native_window.addEventListener(air.Event.CLOSING, function(){t.onBeforeClose();});
		this.native_window.addEventListener("resizing", function(event){
			event.preventDefault();
		});
	},
	
	open: function(){
	  this.native_window.activate(); 
	},
	
	close: function(){
		this.native_window.close();
	},
	
	// raised when new conversation window was opened
	onLoad: function(){
		this.el = $(this.window.document.body.getElement('div#_main'));
		this.reload();
	},
	
	// end the conversation when user closes the window
	onClose: function(){
		this.owner.user.closeProfile(this.info.id);
	},
	
	onBeforeClose: function(){
		if(this.options.editable.length <= 0) return;
		
		var args = new Hash({'id_user': this.info.id});
		var t = this;
		var unchanged = true;
		
		$each(this.options.editable, function(key){
			var value = null;
			
			var el = t.el.getElement('.' + key);
			if(!$defined(el)) return;
			
			el = el.getFirst();
			if(!$defined(el)) return;
			
			if($defined(el.value)){
				value = el.value;
			} else if ($defined(el.text)){
				value = el.text;
			} else {
				return;
			}
			
			unchanged &= (t.info[key] == value) || (t.info[key] == null && value == '');
			args.set(key, value);
		});
		
		// ak pouzivatel nic nezmenil tak sa ho nepytame ci chce ulozit - a teda ani neukladame
		if(unchanged) return;

		if(confirm("Prajete si uložiť zmeny?")){
			this.owner.server.request({'action': 'set_information', 'args': args.getClean()}, function(response){
				t.owner.user.refreshInformation();
			});
		}
	},
	
	reload: function(){
		var t = this;
		
		$each(this.info, function(value, key){
			var el = t.el.getElement('.' + key);
			if(!$defined(el)) return;
			el.empty();
			
			var editable = t.options.editable.contains(key);
			
			if(el.hasClass('type_text')){
				var tpl = 'profile_item_text';
			} else if (el.hasClass('type_textarea')){
				var tpl = 'profile_item_textarea';
			} else {
				return;
			}
			
			if(editable){
				tpl += '_editable';
			}			
			
			var tpl = new Template(tpl);
			var tpl = new Element('div').adopt(tpl.xml).getFirst();
			
			if(editable){
				tpl.set('value', value);
			} else {
				tpl.set('html', value);
			}
			
			el.adopt(tpl);
		});
		
		this.el.getElement('#_info').set('html', (this.options.editable.length > 0) ? 'Informácie sa uložia pri zatvorení okna' : '');
	}
});